/*
 * Decompiled with CFR 0.152.
 */
package jp.sundrystreet.blockbreak;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import jp.sundrystreet.blockbreak.BlockImage;
import jp.sundrystreet.blockbreak.BlockParam;

public class BasePanel
extends JPanel
implements KeyListener,
MouseMotionListener,
ActionListener,
Runnable {
    private static final long serialVersionUID = 2943712251955376719L;
    public static final int WINDOW_WIDTH = 400;
    public static final int WINDOW_HEIGHT = 360;
    static final int FIELD_LEFT = 2;
    static final int FIELD_TOP = 20;
    static final int FIELD_WIDTH = 396;
    static final int FIELD_HEIGHT = 338;
    static final int BAR_RADIUS = 16;
    static final int BAR_Y = 314;
    static final int BALL_RADIUS = 4;
    static final int BLOCK_RADIUS = 22;
    double fVelocity;
    double fArg;
    double fBallX;
    double fBallY;
    double fBallVX;
    double fBallVY;
    int iBarX;
    int iScore;
    int iCombo;
    int iMaxCombo;
    int iTickCount;
    byte iBallRest = 0;
    byte iStage;
    byte iKey = 0;
    BlockParam[] blockParam;
    Font font;
    Font fontBig;
    Font[] fontCombo = new Font[12];
    Color[] colorCombo = new Color[12];
    Image img;
    Image imgBack;
    Image[] imgBlock = new Image[9];
    Thread thread;
    TextField text;
    String name;

    public BasePanel() {
        this.font = new Font("Monospaced", 0, 14);
        this.fontBig = new Font("Courier", 1, 60);
        this.setFont(this.font);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.add(new Label("Input your name."));
        this.text = new TextField(20);
        panel.add(this.text);
        this.add((Component)panel, "Center");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int iKeyCode = e.getKeyCode();
        if (iKeyCode == 10) {
            if (this.iStage <= 0) {
                this.iBallRest = (byte)2;
                this.iStage = 1;
                this.iMaxCombo = 0;
                this.fVelocity = 5.0;
                this.GameStart();
            } else {
                this.iTickCount = this.iTickCount == -1 ? 0 : -1;
            }
        }
        if (iKeyCode == 37) {
            this.iKey = (byte)(this.iKey | 1);
        }
        if (iKeyCode == 39) {
            this.iKey = (byte)(this.iKey | 2);
        }
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int iKeyCode = e.getKeyCode();
        if (iKeyCode == 37) {
            this.iKey = (byte)(this.iKey & 2);
        }
        if (iKeyCode == 39) {
            this.iKey = (byte)(this.iKey & 1);
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.name = e.getActionCommand();
        this.text.removeActionListener(this);
        this.removeAll();
        if (this.name.length() > 20) {
            this.name = this.name.substring(0, 20);
        }
        for (int i = 0; i < this.fontCombo.length; ++i) {
            this.fontCombo[i] = new Font(this.font.getName(), this.font.getStyle(), this.font.getSize() + i * 2);
            this.colorCombo[i] = new Color(0, 255, 0, 255 - i * 255 / this.fontCombo.length);
        }
        this.iStage = 0;
        this.thread = new Thread(this);
        this.thread.start();
        this.addKeyListener(this);
        this.requestFocus();
    }

    public void start() {
        this.img = this.createImage(400, 360);
        this.imgBack = this.createImage(400, 360);
        this.imgBlock[0] = this.createImage(new BlockImage(16750396, 16));
        this.imgBlock[1] = this.createImage(new BlockImage(0x6666FF, 22));
        this.imgBlock[2] = this.createImage(new BlockImage(65535, 22));
        this.imgBlock[3] = this.createImage(new BlockImage(0xFF88F0, 22));
        this.imgBlock[4] = this.createImage(new BlockImage(14177791, 22));
        this.imgBlock[5] = this.createImage(new BlockImage(0xFFFF33, 22));
        this.imgBlock[6] = this.createImage(new BlockImage(65280, 22));
        this.imgBlock[7] = this.createImage(new BlockImage(0x999999, 22));
        this.imgBlock[8] = this.createImage(new BlockImage(0xFF0000, 4));
        this.iStage = (byte)-1;
        this.text.requestFocus();
        this.text.addActionListener(this);
    }

    public void end() {
        this.removeKeyListener(this);
        this.thread = null;
    }

    public String getAppletInfo() {
        return "Block Break - Copyright(C) Yuichi 2002-2004";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.iBarX = e.getX();
        if (this.iBarX < 0) {
            this.iBarX = 0;
        }
        if (this.iBarX > 396) {
            this.iBarX = 396;
        }
        e.consume();
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        while (this.thread == me) {
            this.ShowOpening();
            this.iTickCount = 0;
            while (this.iStage == 0) {
                this.Sleep(50, me);
                if (this.thread != me) {
                    return;
                }
                if (++this.iTickCount != 100) continue;
                this.ShowRanking(me);
                this.iTickCount = 0;
                this.ShowOpening();
            }
            this.iCombo = 0;
            this.iScore = 0;
            block2: while (this.thread == me && this.iStage != 0) {
                this.iTickCount = 1000;
                this.DrawStageEnter("STAGE " + this.iStage);
                this.CreateBlocks();
                this.Sleep(3000, me);
                this.GameStart();
                this.DrawField();
                this.DrawWindow();
                this.Sleep(1000, me);
                while (this.thread == me) {
                    this.fBallX += this.fBallVX;
                    this.fBallY += this.fBallVY;
                    if (this.iKey != 0) {
                        if ((this.iKey & 1) == 1) {
                            this.iBarX -= 8;
                            if (this.iBarX < 0) {
                                this.iBarX = 0;
                            }
                        }
                        if ((this.iKey & 2) == 2) {
                            this.iBarX += 8;
                            if (this.iBarX > 396) {
                                this.iBarX = 396;
                            }
                        }
                    }
                    if (this.CheckBlockHit()) {
                        this.GameEnd();
                        this.DrawStageEnter("CLEAR!");
                        this.iScore += this.iBallRest * 1000;
                        this.Sleep(2000, me);
                        if (this.iStage == 7) {
                            this.DrawFinish(me);
                            this.Sleep(5000, me);
                            ++this.iScore;
                            this.iStage = 1;
                            continue block2;
                        }
                        this.iStage = (byte)(this.iStage + 1);
                        continue block2;
                    }
                    if ((int)this.fBallX < 4) {
                        this.fArg = Math.PI - this.fArg;
                        this.fBallVX *= -1.0;
                        this.fBallX += 4.0 - this.fBallX;
                    } else if ((int)this.fBallX > 392) {
                        this.fArg = Math.PI - this.fArg;
                        this.fBallVX *= -1.0;
                        this.fBallX -= this.fBallX - 392.0;
                    }
                    if ((int)this.fBallY < 4) {
                        this.fArg *= -1.0;
                        this.fBallVY *= -1.0;
                        this.fBallY += 4.0 - this.fBallY;
                    } else if ((int)this.fBallY > 334) {
                        this.GameEnd();
                        if (this.iBallRest == 0) {
                            this.GameOver();
                            this.Sleep(5000, me);
                            this.iStage = 0;
                            continue block2;
                        }
                        this.iBallRest = (byte)(this.iBallRest - 1);
                        this.DrawStageEnter("MISS!");
                        this.Sleep(2000, me);
                        this.GameStart();
                        this.DrawField();
                        this.DrawWindow();
                        this.Sleep(2000, me);
                    }
                    double cx = this.fBallX - (double)this.iBarX;
                    double cy = this.fBallY - 314.0;
                    cx = cx * cx + cy * cy;
                    if (cx < 400.0) {
                        this.ReflectBall(cx, 16, this.iBarX, 314);
                        this.iCombo = 0;
                    }
                    this.DrawWindow();
                    this.Sleep(30, me);
                    if (this.iTickCount == -1) {
                        this.repaint();
                        while (this.iTickCount == -1 && this.thread == me) {
                            this.Sleep(10, me);
                        }
                    }
                    ++this.iTickCount;
                }
            }
        }
    }

    String GetRanking(String arg) {
        byte[] data = new byte[256];
        String strRank = "";
        try {
            int iLength;
            URLConnection connect = new URL("http://phonypianist.sakura.ne.jp/cgi-bin/rank.cgi?type=block" + arg).openConnection();
            connect.setDoInput(true);
            connect.setUseCaches(false);
            connect.connect();
            InputStream stream = connect.getInputStream();
            while ((iLength = stream.read(data)) != -1) {
                strRank = strRank + new String(data, 0, iLength);
            }
            stream.close();
        }
        catch (Exception e) {
            return null;
        }
        return strRank;
    }

    void ShowOpening() {
        Graphics gImg = this.img.getGraphics();
        gImg.setColor(Color.white);
        gImg.fillRect(0, 0, 400, 360);
        gImg.setColor(Color.red);
        gImg.setFont(this.fontBig);
        FontMetrics fm = gImg.getFontMetrics();
        String str = "Block Break";
        gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 100);
        gImg.setFont(this.font);
        fm = gImg.getFontMetrics();
        gImg.setColor(Color.blue);
        str = "Copyright(C) 2002-2004 Yuichi";
        gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 174);
        gImg.setColor(Color.black);
        str = "Press [ENTER] key to start";
        gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 200);
        gImg.dispose();
        this.Flip();
    }

    void ShowRanking(Thread me) {
        Font fontTitle = new Font("Courier", 1, 20);
        String strDownload = this.GetRanking("");
        if (strDownload == null) {
            return;
        }
        StringTokenizer t1 = new StringTokenizer(strDownload, "\n");
        int iRankSize = t1.countTokens();
        String[] strRank = new String[iRankSize];
        String[] strRankName = new String[iRankSize];
        String[] strRankScore = new String[iRankSize];
        String[] strRankCombo = new String[iRankSize];
        int i = 0;
        while (t1.hasMoreTokens()) {
            StringTokenizer t2;
            strRank[i] = "" + (i + 1);
            if (i < 9) {
                strRank[i] = " " + strRank[i];
            }
            if (i < 99) {
                strRank[i] = " " + strRank[i];
            }
            if ((t2 = new StringTokenizer(t1.nextToken(), "\t")).hasMoreTokens()) {
                strRankScore[i] = t2.nextToken();
            }
            if (t2.hasMoreTokens()) {
                strRankCombo[i] = t2.nextToken();
            }
            if (t2.hasMoreTokens()) {
                strRankName[i] = t2.nextToken();
            }
            ++i;
        }
        Graphics gImg = this.img.getGraphics();
        gImg.setColor(Color.white);
        gImg.fillRect(0, 0, 400, 360);
        gImg.setFont(fontTitle);
        String strPrint = "High-Score Ranking";
        FontMetrics fm = gImg.getFontMetrics();
        gImg.setColor(new Color(222, 222, 160));
        gImg.fillRoundRect(10, 3, 380, fm.getHeight() + 4, 12, 12);
        gImg.setColor(Color.cyan);
        gImg.drawString(strPrint, (400 - fm.stringWidth(strPrint)) / 2 + 1, fm.getAscent() + 5);
        gImg.setColor(Color.blue);
        gImg.drawString(strPrint, (400 - fm.stringWidth(strPrint)) / 2, fm.getAscent() + 4);
        gImg.setFont(this.font);
        fm = gImg.getFontMetrics();
        gImg.setColor(Color.red);
        gImg.drawLine(34, 54, 34, 298);
        gImg.drawLine(2, 75, 398, 75);
        gImg.setColor(Color.green);
        gImg.drawString("Score", 62, fm.getAscent() + 52);
        gImg.drawString("Max Combo", 136, fm.getAscent() + 52);
        gImg.drawString("Name", 242, fm.getAscent() + 52);
        int iPage = 0;
        while (!this.isPressedEnterKey(me) && iPage * 10 < iRankSize) {
            int i2;
            gImg.setColor(Color.white);
            gImg.fillRect(1, 82, 32, 278);
            gImg.fillRect(36, 82, 364, 278);
            for (i2 = 0; !this.isPressedEnterKey(me) && i2 < 10 && iPage * 10 + i2 < iRankSize; ++i2) {
                gImg.setColor(Color.red);
                gImg.drawString(strRank[iPage * 10 + i2], 5, (i2 + 2) * 22 + 52);
                for (int j = 9; !this.isPressedEnterKey(me) && j >= 0; --j) {
                    this.Sleep(50, me);
                    gImg.setColor(Color.white);
                    gImg.fillRect(46, (i2 + 2) * 22 + 52 - fm.getAscent(), 370, fm.getHeight());
                    gImg.setColor(Color.black);
                    gImg.drawString(strRankScore[iPage * 10 + i2], 46 + j * 40, (i2 + 2) * 22 + 52);
                    gImg.drawString(strRankCombo[iPage * 10 + i2], 146 + j * 40, (i2 + 2) * 22 + 52);
                    gImg.drawString(strRankName[iPage * 10 + i2], 230 + j * 40, (i2 + 2) * 22 + 52);
                    this.Flip();
                }
            }
            for (i2 = 0; !this.isPressedEnterKey(me) && i2 < 40; ++i2) {
                this.Sleep(40, me);
            }
            ++iPage;
        }
        gImg.dispose();
    }

    boolean isPressedEnterKey(Thread me) {
        return this.thread != me || this.iStage != 0;
    }

    void Sleep(int ms, Thread me) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void ReflectBall(double r, int blockRadius, int x, int y) {
        double t = ((double)(blockRadius + 4) - Math.sqrt(r)) / this.fVelocity;
        this.fBallX -= t * this.fBallVX;
        this.fBallY -= t * this.fBallVY;
        this.fArg = Math.PI + Math.atan2(this.fBallY - (double)y, this.fBallX - (double)x) * 2.0 - this.fArg;
        while (this.fArg >= Math.PI) {
            this.fArg -= Math.PI * 2;
        }
        while (this.fArg < -Math.PI) {
            this.fArg += Math.PI * 2;
        }
        if (this.fArg > -0.01 && this.fArg < 0.01) {
            this.fArg = this.fArg > 0.0 ? 0.011 : -0.011;
        } else if (this.fArg > 3.1315926535897933) {
            this.fArg = 3.130592653589793;
        } else if (this.fArg < -3.1315926535897933) {
            this.fArg = -3.130592653589793;
        }
        this.fBallVX = this.fVelocity * Math.cos(this.fArg);
        this.fBallVY = this.fVelocity * Math.sin(this.fArg);
        this.fBallX += (t + 0.1) * this.fBallVX;
        this.fBallY += (t + 0.1) * this.fBallVY;
    }

    boolean CheckBlockHit() {
        int n = 0;
        for (int i = 0; i < this.blockParam.length; ++i) {
            if (this.blockParam[i].hit == 0) {
                ++n;
                continue;
            }
            if (this.blockParam[i].hit == 7) {
                ++n;
            }
            double cx = this.fBallX - (double)this.blockParam[i].x;
            double cy = this.fBallY - (double)this.blockParam[i].y;
            if (!((cx = cx * cx + cy * cy) < 676.0)) continue;
            this.ReflectBall(cx, 22, this.blockParam[i].x, this.blockParam[i].y);
            if (this.blockParam[i].hit != 7) {
                --this.blockParam[i].hit;
                this.iScore += ++this.iCombo * 10;
                this.iTickCount = 0;
                if (this.iCombo > this.iMaxCombo) {
                    this.iMaxCombo = this.iCombo;
                }
            }
            Graphics gImgBack = this.imgBack.getGraphics();
            gImgBack.setClip(2, 20, 396, 338);
            if (this.blockParam[i].hit > 0) {
                gImgBack.drawImage(this.imgBlock[this.blockParam[i].hit], this.blockParam[i].x - 22 + 2, this.blockParam[i].y - 22 + 20, this);
            } else {
                gImgBack.setColor(Color.white);
                gImgBack.fillRect(this.blockParam[i].x - 22 + 2, this.blockParam[i].y - 22 + 20, 44, 44);
            }
            gImgBack.setClip(0, 0, 400, 360);
            gImgBack.dispose();
        }
        return n == this.blockParam.length;
    }

    @Override
    public synchronized void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this);
        if (this.iTickCount == -1) {
            g.setFont(this.fontBig);
            FontMetrics fm = g.getFontMetrics();
            String str = "PAUSE";
            int width = fm.stringWidth(str);
            int left = (400 - width) / 2;
            int height = fm.getHeight();
            int top = 20 + (338 - height) / 2;
            g.setColor(new Color(160, 160, 160, 127));
            g.fillRect(left, top, fm.stringWidth(str), height);
            g.setColor(Color.gray);
            g.drawRect(left - 1, top - 1, fm.stringWidth(str) + 1, height + 1);
            g.setColor(new Color(60, 200, 60, 160));
            g.drawString(str, left, top + fm.getAscent());
            g.setFont(this.font);
        }
    }

    synchronized void DrawField() {
        int i;
        Graphics gImgBack = this.imgBack.getGraphics();
        gImgBack.setColor(Color.white);
        gImgBack.fillRect(0, 0, 400, 360);
        gImgBack.setClip(2, 20, 396, 338);
        for (i = 0; i < this.blockParam.length; ++i) {
            if (this.blockParam[i].hit <= 0) continue;
            gImgBack.drawImage(this.imgBlock[this.blockParam[i].hit], this.blockParam[i].x - 22 + 2, this.blockParam[i].y - 22 + 20, this);
        }
        gImgBack.setClip(0, 0, 400, 360);
        gImgBack.setColor(new Color(255, 255, 190));
        gImgBack.fillRect(0, 0, 400, 20);
        gImgBack.setColor(Color.gray);
        gImgBack.drawRect(1, 19, 397, 339);
        gImgBack.setColor(Color.black);
        gImgBack.drawRect(0, 18, 398, 340);
        gImgBack.setColor(Color.red);
        gImgBack.drawString("STAGE " + this.iStage, 10, 16);
        gImgBack.setColor(Color.red);
        gImgBack.drawString("REST", 130, 16);
        for (i = 0; i < this.iBallRest; ++i) {
            gImgBack.drawImage(this.imgBlock[8], 166 + i * 12, 6, this);
        }
        gImgBack.dispose();
    }

    synchronized void Flip() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.drawImage(this.img, 0, 0, this);
        g.dispose();
    }

    synchronized void DrawWindow() {
        Graphics gImg = this.img.getGraphics();
        gImg.drawImage(this.imgBack, 0, 0, this);
        gImg.setClip(2, 20, 396, 338);
        gImg.drawImage(this.imgBlock[0], this.iBarX - 16 + 2, 318, this);
        gImg.drawImage(this.imgBlock[8], (int)this.fBallX - 4 + 2, (int)this.fBallY - 4 + 20, this);
        gImg.setClip(0, 0, 400, 360);
        gImg.setColor(Color.red);
        gImg.drawString("SCORE " + this.iScore, 250, 16);
        if (this.iCombo >= 2 && this.iTickCount < 30) {
            String str = "COMBO " + this.iCombo;
            gImg.setFont(this.font);
            FontMetrics fm = gImg.getFontMetrics();
            gImg.setColor(new Color(99, 99, 99, 170));
            gImg.fillRoundRect(22, 40, fm.stringWidth(str) + 4, fm.getHeight() + 4, 6, 6);
            gImg.setColor(new Color(150, 255, 150));
            gImg.drawString(str, 25, 42 + fm.getAscent());
            if (this.iTickCount < this.fontCombo.length) {
                gImg.setColor(this.colorCombo[this.iTickCount]);
                gImg.setFont(this.fontCombo[this.iTickCount]);
                gImg.drawString(str, 25, 54);
            }
        }
        gImg.dispose();
        this.Flip();
    }

    synchronized void DrawStageEnter(String str) {
        Graphics gImg = this.img.getGraphics();
        this.iCombo = 0;
        gImg.setColor(Color.black);
        gImg.fillRect(0, 0, 400, 360);
        gImg.setColor(Color.white);
        gImg.setFont(this.fontBig);
        FontMetrics fm = gImg.getFontMetrics();
        gImg.drawString(str, (396 - fm.stringWidth(str)) / 2, (fm.getAscent() + 338) / 2);
        gImg.dispose();
        this.Flip();
    }

    synchronized void GameOver() {
        Graphics gImg;
        block4: {
            gImg = this.img.getGraphics();
            gImg.setColor(Color.black);
            gImg.fillRect(0, 0, 400, 360);
            gImg.setColor(Color.white);
            gImg.setFont(this.fontBig);
            FontMetrics fm = gImg.getFontMetrics();
            String str = "Game Over";
            gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, fm.getAscent() + 20);
            gImg.setColor(Color.yellow);
            str = "Score";
            gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 180);
            str = Integer.toString(this.iScore);
            gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 230);
            this.Flip();
            try {
                String accessUrl = "&name=" + URLEncoder.encode(this.name, StandardCharsets.UTF_8.name()) + "&score=" + this.iScore + "&combo=" + this.iMaxCombo + "&crc=" + (this.iScore - this.iMaxCombo * 53);
                str = this.GetRanking(accessUrl);
                if (str == null) break block4;
                StringTokenizer t1 = new StringTokenizer(str, "\n");
                int n = 1;
                while (t1.hasMoreTokens()) {
                    StringTokenizer t2 = new StringTokenizer(t1.nextToken(), "\t");
                    int score = Integer.parseInt(t2.nextToken().replace(' ', '0'));
                    int combo = Integer.parseInt(t2.nextToken().replace(' ', '0'));
                    if (t2.nextToken().equals(this.name) && score == this.iScore && combo == this.iMaxCombo) {
                        gImg.setColor(Color.cyan);
                        str = "Rank " + n;
                        gImg.drawString(str, (400 - fm.stringWidth(str)) / 2, 336);
                        break;
                    }
                    ++n;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        gImg.dispose();
        this.Flip();
    }

    synchronized void DrawFinish(Thread me) {
        int i;
        Graphics gImg = this.img.getGraphics();
        String str = "CLEAR!";
        float[] vParticlesX = new float[400];
        float[] vParticlesY = new float[vParticlesX.length];
        for (i = 0; i < vParticlesX.length; ++i) {
            float v = (float)(Math.random() * 20.0);
            float fArg = (float)(Math.random() * Math.PI * 2.0);
            vParticlesX[i] = (float)((double)v * Math.sin(fArg));
            vParticlesY[i] = (float)((double)v * Math.cos(fArg));
        }
        for (i = 0; i < 36; ++i) {
            gImg.setColor(Color.black);
            gImg.fillRect(0, 0, 400, 360);
            gImg.setColor(Color.yellow);
            for (int j = 0; j < vParticlesX.length; ++j) {
                gImg.fillRect(200 + (int)(vParticlesX[j] * (float)i), 180 + (int)(vParticlesY[j] * (float)i), 3, 3);
            }
            gImg.setColor(Color.darkGray);
            gImg.fillOval(200 - i * 5, 180 - i * 5, i * 10, i * 10);
            gImg.setColor(Color.gray);
            gImg.fillOval(200 - i * 5 + 5, 180 - i * 5 + 5, i * 10 - 10, i * 10 - 10);
            gImg.setColor(Color.lightGray);
            gImg.fillOval(200 - i * 5 + 10, 180 - i * 5 + 10, i * 10 - 20, i * 10 - 20);
            gImg.setColor(Color.white);
            gImg.fillOval(200 - i * i / 4 + 15, 180 - i * i / 4 + 15, i * i / 2 - 30, i * i / 2 - 30);
            this.Flip();
            if (this.thread != me) {
                return;
            }
            this.Sleep(30, me);
        }
        gImg.setFont(this.fontBig);
        FontMetrics fm = gImg.getFontMetrics();
        for (i = 0; i < 16; ++i) {
            gImg.setColor(Color.black);
            gImg.fillRect(0, 0, 400, 360);
            gImg.setColor(Color.gray);
            gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2 + i - 8, 75);
            gImg.setColor(Color.white);
            gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 70);
            this.Flip();
            if (this.thread != me) {
                return;
            }
            this.Sleep(30, me);
        }
        gImg.setColor(Color.yellow);
        str = "SCORE";
        gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 130);
        this.Flip();
        if (this.thread != me) {
            return;
        }
        this.Sleep(500, me);
        str = Integer.toString(this.iScore);
        gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 185);
        this.Flip();
        if (this.thread != me) {
            return;
        }
        this.Sleep(500, me);
        gImg.setColor(Color.green);
        str = "MAX COMBO";
        gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 240);
        this.Flip();
        if (this.thread != me) {
            return;
        }
        this.Sleep(500, me);
        str = Integer.toString(this.iMaxCombo);
        gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 295);
        this.Flip();
        if (this.iBallRest == 2) {
            this.Sleep(3000, me);
            if (this.thread != me) {
                return;
            }
            str = "PERFECT!";
            gImg.setColor(Color.blue);
            gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2 + 3, 192);
            gImg.setColor(Color.cyan);
            gImg.drawString(str, 2 + (396 - fm.stringWidth(str)) / 2, 189);
            this.Flip();
        }
        gImg.dispose();
    }

    void CreateBlocks() {
        switch (this.iStage) {
            case 1: {
                this.blockParam = new BlockParam[8];
                for (int i = 0; i < 8; ++i) {
                    this.blockParam[i] = new BlockParam();
                    this.blockParam[i].hit = 1;
                    this.blockParam[i].x = 198 + (i * 2 - 7) * 22;
                    this.blockParam[i].y = 44;
                }
                break;
            }
            case 2: {
                this.blockParam = new BlockParam[12];
                for (int j = 0; j <= 1; ++j) {
                    for (int i = 0; i < 6; ++i) {
                        int index = i + j * 6;
                        this.blockParam[index] = new BlockParam();
                        this.blockParam[index].hit = j * 2 + 1;
                        this.blockParam[index].x = 198 + (i * 2 - 5) * 22 * 3 / 2;
                        this.blockParam[index].y = 22 * (j * 3 + 2);
                    }
                }
                break;
            }
            case 3: {
                int i;
                this.blockParam = new BlockParam[14];
                for (int j = 0; j <= 1; ++j) {
                    for (i = 0; i < 5; ++i) {
                        int index = i + j * 5;
                        this.blockParam[index] = new BlockParam();
                        this.blockParam[index].hit = j * 4 + 2;
                        this.blockParam[index].x = 198 + (i - 2) * 22 * 4;
                        this.blockParam[index].y = 22 * (j * 3 + 2);
                    }
                }
                for (i = 10; i < 14; ++i) {
                    this.blockParam[i] = new BlockParam();
                    this.blockParam[i].hit = 4;
                    this.blockParam[i].x = 198 + (i * 2 - 23) * 22 * 2;
                    this.blockParam[i].y = 77;
                }
                break;
            }
            case 4: {
                this.blockParam = new BlockParam[18];
                for (int j = 0; j <= 2; ++j) {
                    for (int i = 0; i < 6; ++i) {
                        int index = i + j * 6;
                        this.blockParam[index] = new BlockParam();
                        this.blockParam[index].hit = 4 + j;
                        this.blockParam[index].x = 198 + (i * 2 - 5) * 22 * 3 / 2;
                        this.blockParam[index].y = 22 * (j * 2 + 1);
                    }
                }
                break;
            }
            case 5: {
                this.blockParam = new BlockParam[18];
                for (int j = 0; j <= 1; ++j) {
                    for (int i = 0; i < 9; ++i) {
                        int index = i + j * 9;
                        this.blockParam[index] = new BlockParam();
                        this.blockParam[index].hit = j * 5 + 1;
                        this.blockParam[index].x = 198 + (i - 4) * 22 * 2;
                        this.blockParam[index].y = 22 * (j * 3 + 1);
                    }
                }
                break;
            }
            case 6: {
                int i;
                this.blockParam = new BlockParam[14];
                for (i = 0; i < 5; ++i) {
                    this.blockParam[i] = new BlockParam();
                    this.blockParam[i].hit = 7;
                    this.blockParam[i].x = 198 + (i - 2) * 22 * 3;
                    this.blockParam[i].y = 92;
                }
                for (i = 5; i < 14; ++i) {
                    this.blockParam[i] = new BlockParam();
                    this.blockParam[i].hit = 5 - Math.abs(i - 9);
                    this.blockParam[i].x = 198 + (i - 9) * 22 * 2;
                    this.blockParam[i].y = 26;
                }
                break;
            }
            default: {
                this.blockParam = new BlockParam[24];
                for (int j = 0; j < 3; ++j) {
                    for (int i = 0; i < 8; ++i) {
                        int index = i + j * 8;
                        this.blockParam[index] = new BlockParam();
                        this.blockParam[index].hit = j + 5;
                        this.blockParam[index].x = 198 + (i * 2 - 7) * 22;
                        this.blockParam[index].y = 22 * (j * 5 + 1) / 2;
                    }
                }
            }
        }
    }

    void GameStart() {
        this.iBarX = 198;
        this.fBallX = this.iBarX;
        this.fBallY = 248.0;
        this.fVelocity += 0.2;
        this.fArg = Math.random() * Math.PI / 2.0 - 2.356194490192345;
        this.fBallVX = this.fVelocity * Math.cos(this.fArg);
        this.fBallVY = this.fVelocity * Math.sin(this.fArg);
        this.addMouseMotionListener(this);
    }

    void GameEnd() {
        this.removeMouseMotionListener(this);
    }
}

