/*
 * Decompiled with CFR 0.152.
 */
package jp.sundrystreet.blockbreak;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public class BlockImage
implements ImageProducer {
    private int iColor;
    private int iRadius;

    public BlockImage(int iColor, int iRadius) {
        this.iColor = iColor;
        this.iRadius = iRadius;
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return false;
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        int y;
        int x;
        int i;
        int j;
        int[] image = new int[this.iRadius * this.iRadius * 4];
        ic.setDimensions(this.iRadius * 2, this.iRadius * 2);
        ic.setHints(30);
        ColorModel cm = ColorModel.getRGBdefault();
        ic.setColorModel(cm);
        int iLightX = this.iRadius * 4 / 3;
        int iLightY = this.iRadius * 2 / 3;
        float[] hsbvals = new float[3];
        for (j = 0; j < this.iRadius * 2; ++j) {
            for (i = 0; i < this.iRadius * 2; ++i) {
                x = i - this.iRadius;
                y = j - this.iRadius;
                if (x * x + y * y > (this.iRadius - 1) * (this.iRadius - 1)) {
                    image[i + j * this.iRadius * 2] = 0xFFFFFF;
                    continue;
                }
                double d = Math.sqrt((iLightX - i) * (iLightX - i) + (iLightY - j) * (iLightY - j));
                Color.RGBtoHSB(this.iColor >> 16 & 0xFF, this.iColor >> 8 & 0xFF, this.iColor & 0xFF, hsbvals);
                hsbvals[2] = (float)((double)hsbvals[2] - (d / (double)(this.iRadius * 2) - 0.05));
                if (hsbvals[2] < 0.0f) {
                    hsbvals[2] = 0.0f;
                }
                if (hsbvals[2] > 1.0f) {
                    hsbvals[2] = 1.0f;
                }
                image[i + j * this.iRadius * 2] = 0xFF000000 | Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]);
            }
        }
        int[] image2 = new int[image.length];
        System.arraycopy(image, 0, image2, 0, image.length);
        for (j = 0; j < this.iRadius * 2; ++j) {
            for (i = 0; i < this.iRadius * 2; ++i) {
                x = i - this.iRadius;
                y = j - this.iRadius;
                if (x * x + y * y > this.iRadius * this.iRadius || x * x + y * y <= (this.iRadius - 1) * (this.iRadius - 1)) continue;
                int b = 0;
                int g = 0;
                int r = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        if (i + dx >= 0 && i + dx < this.iRadius * 2 && j + dy >= 0 && j + dy < this.iRadius * 2) {
                            r += image[i + dx + (j + dy) * this.iRadius * 2] >> 16 & 0xFF;
                            g += image[i + dx + (j + dy) * this.iRadius * 2] >> 8 & 0xFF;
                            b += image[i + dx + (j + dy) * this.iRadius * 2] & 0xFF;
                            continue;
                        }
                        r += 255;
                        g += 255;
                        b += 255;
                    }
                }
                image2[i + j * this.iRadius * 2] = 0xFF000000 | (r /= 9) << 16 | (g /= 9) << 8 | (b /= 9);
            }
        }
        image = image2;
        for (i = 0; i < this.iRadius * 2; ++i) {
            ic.setPixels(0, i, this.iRadius * 2, 1, cm, image, i * this.iRadius * 2, this.iRadius * 2);
        }
        ic.imageComplete(3);
        System.gc();
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }
}

